//////////////////////////////////////////////////////////////////////////
// This is a clean prefpage with a treeoption control 
// I avoided unnecessary code obfuscation as good as possible
#include "stdafx.h"
#include "emule.h"
#include "Version.h" 
#include "PPgTweaks2.h"
#include "Preferences.h"
#include "Version.h"
#include "otherfunctions.h"
#include "UserMsgs.h"
#include "Sion/Cp/PreferencesDlg.h"
#include "opcodes.h"
#include "PartFile.h"
#include "DownloadQueue.h" 
#include "emuleDlg.h"
#include "transferwnd.h"
#include "serverwnd.h"
#include "searchdlg.h"
#include "searchresultswnd.h"
#include "TransferWnd.h"
#include "emuledlg.h"
#include "SharedFilesWnd.h"
#include "TransferWnd.h" //dlarge CPU/MEM 

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#define new DEBUG_NEW
#endif


IMPLEMENT_DYNAMIC(CPPgTweaks2, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgTweaks2, CPropertyPage)
	ON_WM_HSCROLL()	
	ON_WM_DESTROY()
	ON_MESSAGE(WM_TREEOPTSCTRL_NOTIFY, OnTreeOptsCtrlNotify) // NEO: FIX - [TreeControl] <-- Loulach --
END_MESSAGE_MAP()

CPPgTweaks2::CPPgTweaks2()
: CPropertyPage(CPPgTweaks2::IDD)
, m_ctrlTreeOptions(theApp.m_iDfltImageListColorFlags)
{

//dlarge high process priority 
	m_htiHighProcess = NULL;
	m_htiHighProcessMode_low = NULL;
	m_htiHighProcessMode_lower = NULL;
	m_htiHighProcessMode_normal = NULL;
	m_htiHighProcessMode_higher = NULL;
	m_htiHighProcessMode_high = NULL;
	m_iHighProcessMode = 0;
//dlarge end

//dlarge auto priority
	hGrpAPrio = NULL;
	hUseAPrio = NULL;
	hAPrioHigh = NULL;
	hAPrioNorm = NULL;
	hAPrioKeepLow = NULL;
//dlarge end

//dlarge SUC
	m_htiMoreTweaksGroup = NULL;
	m_htiDynUpSUC = NULL;
	m_htiSUCLog = NULL;
	m_htiSUCHigh = NULL;
	m_htiSUCLow = NULL;
	m_htiSUCPitch = NULL;
	m_htiSUCDrift = NULL;
//dlarge end

//dlarge QuickStart
		m_htiQuickStart = NULL;
			m_htiQuickStartEnable = NULL;
			m_htiQuickStartTime = NULL;
			//m_htiQuickStartTimePerFile = NULL;
			m_htiQuickMaxConperFive = NULL;
			m_htiQuickMaxHalfOpen = NULL;
			m_htiQuickMaxConnections = NULL;
//dlarge end

//dlarge Drop
	m_htiDropSources = NULL;
	m_htiDropSourcesTimerNNS = NULL;
	m_htiDropSourcesTimerFQ = NULL;
	m_htiDropSourcesTimerHQR = NULL;
	m_htiDropSourcesNNS = NULL;
	m_htiDropSourcesFQ = NULL;
	m_htiDropSourcesHQR = NULL;
    m_htiHqrBox = NULL;
//dlarge end

// NEO: NMX - [NeoMenuXP]
	m_htiXPMenuStyle = NULL;
	m_htiXPMenuStyleOffice = NULL;
	m_htiXPMenuStyleStartMenu = NULL;
	m_htiXPMenuStyleXP = NULL;
	m_htiShowXPSideBar = NULL;
	m_htiShowXPBitmap = NULL;
	m_htiGrayMenuIcon = NULL;
// NEO: NMX END

//dlarge CPU/MEM 
	m_htiSysInfoGroup = NULL;
	m_htiSysInfo = NULL;
	m_htiSysInfoGlobal = NULL;
//dlarge end 

//dlarge Display Settings
	m_htiQueueProgressBar = NULL; //dlarge Client queue progress bar 
	m_htiShowClientPercentage = NULL; //dlarge Client Percentage 
	m_htiEnableChunkDots = NULL; //dlarge ChunkDots
	m_htiSessionDownload = NULL; //dlarge Session Download
//dlarg end

//dlarge minimule 
	m_htiMMGroup = NULL;
	m_htiShowMM = NULL;
	m_htiMMLives = NULL;
	m_htiMMUpdateTime = NULL;
	m_htiMMTrans = NULL;
	m_htiMMCompl = NULL;
	m_htiMMOpen = NULL;
//dlarge end

//dlarge Smart Category Control 
	m_htiSCC = NULL;
	m_htiDlMode = NULL;
	m_htiDlNone = NULL;
	m_htiDlAlph = NULL;
	m_htiDlLP = NULL;
	m_htiShowCatNames = NULL;
	m_htiSelectCat = NULL;
	m_htiUseActiveCat = NULL;
	m_htiAutoSetResOrder = NULL;
	m_htiSmallFileDLPush = NULL;
	m_htiResumeFileInNewCat = NULL;
	m_htiUseAutoCat = NULL;
//dlarge end

//dlarge Misc Settings
	m_htiMisc = NULL;
	m_htiSUQWT = NULL; //dlarge SUQWT 
	m_htiStaticIcon = NULL; //dlarge Static Tray Icon
	m_htiTrayComplete = NULL; //dlarge Completed in Tray 
	m_htiAutoSharedUpdater = NULL; //dlarge Automatic shared files updater 

	m_bInitializedTreeOpts = false;
}

CPPgTweaks2::~CPPgTweaks2()
{
}

void CPPgTweaks2::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TWEAKS2_OPTS, m_ctrlTreeOptions);
	CString buffer;
	if (!m_bInitializedTreeOpts)
	{
		int iImgSCC = 8; //dlarge Smart Category Control
		int iImgDlMode = 8; //dlarge Smart Category Control
		int iImgMisc = 8; //dlarge Misc Settings
                int iImgDrop = 8; //dlarge Drop
                int iImgProcessPrio = 8; //dlarge ProcessPrio
                int iLmgQS = 8;//dlarge QuickStart
		int iImgAPrio = 8; //dlarge auto priority
		int iImgSUC = NULL; //dlarge SUC
                int iImgXP = 0; // NEO: NMX - [NeoMenuXP]
		int iImgSysInfo = 8;
		int iImgMinimule = 8;

		CImageList* piml = m_ctrlTreeOptions.GetImageList(TVSIL_NORMAL);
		if (piml)
		{
			iImgSCC = piml->Add(CTempIconLoader(_T("CATEGORY"))); //dlarge Smart Category Control
			iImgDlMode = piml->Add(CTempIconLoader(_T("DLMODE"))); //dlarge Smart Category Control
			iImgMisc = piml->Add(CTempIconLoader(_T("SRCUNKNOWN"))); //dlarge Misc Settings
                        iImgDrop = piml->Add(CTempIconLoader(_T("DROP")));//dlarge Drop
		        iLmgQS = piml->Add(CTempIconLoader(_T("QUICKSTART")));//dlarge QuickStart	
	                iImgProcessPrio = piml->Add(CTempIconLoader(_T("PRIOSILVER"))); //dlarge ProcessPrio   
			iImgAPrio = piml->Add(CTempIconLoader(_T("FILEPRIORITY"))); //dlarge auto priority
			iImgSUC = piml->Add(CTempIconLoader(_T("SUC")));  //dlarge SUC
			iImgXP = piml->Add(CTempIconLoader(_T("MenuXP"))); // NEO: NMX - [NeoMenuXP]
			iImgSysInfo = piml->Add(CTempIconLoader(_T("STATISTICS")));
			iImgMinimule = piml->Add(CTempIconLoader(_T("MINIMULE"))); //dlarge Minimule
		}

	//dlarge auto priority
		hGrpAPrio = m_ctrlTreeOptions.InsertGroup(_T("Download Auto-Priority"), iImgAPrio, TVI_ROOT);
		hUseAPrio = m_ctrlTreeOptions.InsertCheckBox(_T("Use AutoPrio"), hGrpAPrio, bUseAPrio);
		hAPrioHigh = m_ctrlTreeOptions.InsertItem(_T("Auto High Prio above this %"), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, hGrpAPrio);
		m_ctrlTreeOptions.AddEditBox(hAPrioHigh, RUNTIME_CLASS(CNumTreeOptionsEdit));
		hAPrioNorm = m_ctrlTreeOptions.InsertItem(_T("Auto Normal Prio above this %"), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, hGrpAPrio);
		m_ctrlTreeOptions.AddEditBox(hAPrioNorm, RUNTIME_CLASS(CNumTreeOptionsEdit));
		hAPrioKeepLow = m_ctrlTreeOptions.InsertCheckBox(_T("Auto low priority below normal %"), hGrpAPrio, bAPrioKeepLow);
	//dlarge end

//dlarge high process priority 
		WORD wWinVer = thePrefs.GetWindowsVersion();	// maybe causes problems on 98 & nt4
		bool bW2kHigher = true;
		if(wWinVer == _WINVER_95_ || wWinVer == _WINVER_98_ || wWinVer == _WINVER_ME_ || wWinVer == _WINVER_NT4_)	
		bW2kHigher = false;
		m_htiHighProcess = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_HIGHPROCESS), iImgProcessPrio, TVI_ROOT);
		m_htiHighProcessMode_low = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_LOW_PROCESS), m_htiHighProcess, m_iHighProcessMode == 0);
		if(bW2kHigher) // not supported in < W2k
			m_htiHighProcessMode_lower = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_LOWER_PROCESS), m_htiHighProcess, m_iHighProcessMode == 1);
		m_htiHighProcessMode_normal = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_NORMAL_PROCESS), m_htiHighProcess, m_iHighProcessMode == 2);
		if(bW2kHigher) // not supported in < W2k
			m_htiHighProcessMode_higher = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_HIGHER_PROCESS), m_htiHighProcess, m_iHighProcessMode == 3);
		m_htiHighProcessMode_high = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_HIGH_PROCESS), m_htiHighProcess, m_iHighProcessMode == 4);
//dlarge end 

// dlarge QuickStart
			m_htiQuickStart = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_QUICK_START),iLmgQS, TVI_ROOT);
				m_htiQuickStartEnable = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_X_QUICK_START_ENABLE),m_htiQuickStart);
				m_htiQuickStartTime = m_ctrlTreeOptions.InsertItem(GetResString(IDS_X_QUICK_START_TIME), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiQuickStart);
				m_ctrlTreeOptions.AddEditBox(m_htiQuickStartTime, RUNTIME_CLASS(CNumTreeOptionsEdit));
				//m_htiQuickStartTimePerFile = m_ctrlTreeOptions.InsertItem(GetResString(IDS_X_QUICK_START_TIME_PER_FILE), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiQuickStart);
				//m_ctrlTreeOptions.AddEditBox(m_htiQuickStartTimePerFile, RUNTIME_CLASS(CNumTreeOptionsEdit));
				m_htiQuickMaxConperFive = m_ctrlTreeOptions.InsertItem(GetResString(IDS_X_QUICK_START_MAXPER5), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiQuickStart);
				m_ctrlTreeOptions.AddEditBox(m_htiQuickMaxConperFive, RUNTIME_CLASS(CNumTreeOptionsEdit));
				m_htiQuickMaxHalfOpen = m_ctrlTreeOptions.InsertItem(GetResString(IDS_X_QUICK_START_MAXHALF), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiQuickStart);
				m_ctrlTreeOptions.AddEditBox(m_htiQuickMaxHalfOpen, RUNTIME_CLASS(CNumTreeOptionsEdit));
				m_htiQuickMaxConnections = m_ctrlTreeOptions.InsertItem(GetResString(IDS_X_QUICK_START_MAXCON), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiQuickStart);
				m_ctrlTreeOptions.AddEditBox(m_htiQuickMaxConnections, RUNTIME_CLASS(CNumTreeOptionsEdit));
// dlarge end

//dlarge Drop
		m_htiDropSources = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_DROPS), iImgDrop, TVI_ROOT);
		m_htiDropSourcesNNS = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_DROPS1), m_htiDropSources, m_iDropSources = 1);
		m_htiDropSourcesTimerNNS = m_ctrlTreeOptions.InsertItem(GetResString(IDS_DROPS2), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiDropSources);
		m_ctrlTreeOptions.AddEditBox(m_htiDropSourcesTimerNNS, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiDropSourcesFQ = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_DROPS3), m_htiDropSources, m_iDropSources = 3);
		m_htiDropSourcesTimerFQ = m_ctrlTreeOptions.InsertItem(GetResString(IDS_DROPS2), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiDropSources);
		m_ctrlTreeOptions.AddEditBox(m_htiDropSourcesTimerFQ, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiDropSourcesHQR = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_DROPS4), m_htiDropSources, m_iDropSources = 7);
		m_htiDropSourcesTimerHQR = m_ctrlTreeOptions.InsertItem(GetResString(IDS_DROPS2), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiDropSources);
		m_ctrlTreeOptions.AddEditBox(m_htiDropSourcesTimerHQR, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiHqrBox = m_ctrlTreeOptions.InsertItem(GetResString(IDS_DROPHQSLIMIT), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiDropSources);
		m_ctrlTreeOptions.AddEditBox(m_htiHqrBox , RUNTIME_CLASS(CNumTreeOptionsEdit));
//dlarge end

//dlarge SUC
                CString Buffer;
	        m_htiMoreTweaksGroup = m_ctrlTreeOptions.InsertGroup(_T("Upload Options"), iImgSUC, TVI_ROOT);
		m_htiDynUpSUC = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_SUC), m_htiMoreTweaksGroup, m_bDynUpMode);
		Buffer.Format(GetResString(IDS_SUC_HIGH),900);
		m_htiSUCHigh = m_ctrlTreeOptions.InsertItem(Buffer, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiDynUpSUC);
		m_ctrlTreeOptions.AddEditBox(m_htiSUCHigh, RUNTIME_CLASS(CNumTreeOptionsEdit));
		Buffer.Format(GetResString(IDS_SUC_LOW),600);
		m_htiSUCLow = m_ctrlTreeOptions.InsertItem(Buffer, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiDynUpSUC);
		m_ctrlTreeOptions.AddEditBox(m_htiSUCLow, RUNTIME_CLASS(CNumTreeOptionsEdit));
		Buffer.Format(GetResString(IDS_SUC_PITCH),3000);
		m_htiSUCPitch = m_ctrlTreeOptions.InsertItem(Buffer, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiDynUpSUC);
		m_ctrlTreeOptions.AddEditBox(m_htiSUCPitch, RUNTIME_CLASS(CNumTreeOptionsEdit));
		Buffer.Format(GetResString(IDS_SUC_DRIFT),50);
		m_htiSUCDrift = m_ctrlTreeOptions.InsertItem(Buffer, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiDynUpSUC);
		m_ctrlTreeOptions.AddEditBox(m_htiSUCDrift, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiSUCLog = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_SUC_LOG), m_htiDynUpSUC, m_bSUCLog);
//dlarge SUC

		m_htiXPMenu = m_ctrlTreeOptions.InsertGroup(_T("Display Settings"),iImgXP, TVI_ROOT);
// NEO: NMX - [NeoMenuXP]
		m_htiXPMenuStyle  = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_X_XP_MENU_STYLE),iImgXP, m_htiXPMenu);
		m_htiXPMenuStyleOffice  = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_X_OFFICE_MENUS),m_htiXPMenuStyle,m_iXPMenuStyle == 0);
		m_htiXPMenuStyleStartMenu = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_X_START_MENUS),m_htiXPMenuStyle,m_iXPMenuStyle == 1);
		m_htiXPMenuStyleXP = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_X_XP_MENUS),m_htiXPMenuStyle,m_iXPMenuStyle == 2);
		m_htiShowXPSideBar = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_X_SHOW_XP_SIDEBAR),m_htiXPMenuStyle,m_bShowXPSideBar);
		m_htiShowXPBitmap = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_X_SHOW_XP_BITMAP),m_htiXPMenuStyle,m_bShowXPBitmap);
		m_htiGrayMenuIcon = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_X_GRAY_MENU_ICON),m_htiXPMenuStyle,m_bGrayMenuIcon);
// NEO: NMX END

//dlarge CPU/MEM 
		m_htiSysInfoGroup = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_SYS_INFO_GROUP), iImgSysInfo, m_htiXPMenu);
		m_htiSysInfo = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_SUC_ENABLED), m_htiSysInfoGroup, m_bSysInfo);
		m_htiSysInfoGlobal = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_SYS_INFO_GLOBAL), m_htiSysInfoGroup, m_bSysInfoGlobal);
//dlarge end 

//dlarge Display Settings
		m_htiQueueProgressBar = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_CLIENTQUEUEPROGRESSBAR), m_htiXPMenu, m_bQueueProgressBar); //dlarge Client queue progress bar 
		m_htiShowClientPercentage = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_CLIENTPERCENTAGE), m_htiXPMenu, m_bShowClientPercentage); //dlarge Client Percentage 
		m_htiEnableChunkDots = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_ENABLE_CHUNKDOTS), m_htiXPMenu, m_bEnableChunkDots);//dlarge ChunkDots
		m_htiSessionDownload = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_SESSION_DOWNLOAD), m_htiXPMenu, m_bShowSessionDownload);//dlarge Session Download
//dlarge end

//dlarge minimule 
		m_htiMMGroup = m_ctrlTreeOptions.InsertGroup(_T("Mini-Mule Settings"), iImgMinimule, TVI_ROOT);
		m_htiShowMM = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_MM_SHOW), m_htiMMGroup, m_bShowMM);
		m_htiMMLives = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_MM_LIVES), m_htiMMGroup, m_bMMLives);
		m_htiMMUpdateTime = m_ctrlTreeOptions.InsertItem(GetResString(IDS_MM_UPDATE_TIME), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiMMGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiMMUpdateTime, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiMMTrans = m_ctrlTreeOptions.InsertItem(GetResString(IDS_MM_TRANS), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiMMGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiMMTrans, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiMMCompl = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_MM_COMPL), m_htiMMGroup, m_bMMCompl);
		m_htiMMOpen = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_MM_OPEN), m_htiMMGroup, m_bMMOpen);
//dlarge end

//dlarge Smart Category Control 
		m_htiSCC = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_SCC), iImgSCC, TVI_ROOT);
		m_htiDlMode = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_DL_MODE_DEFAULT), iImgDlMode, m_htiSCC);
		m_htiDlNone = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_DL_NONE), m_htiDlMode, m_iDlMode == 0);
		m_htiDlAlph = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_DOWNLOAD_ALPHABETICAL), m_htiDlMode, m_iDlMode == 1);
		m_htiDlLP = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_LP), m_htiDlMode, m_iDlMode == 2);
		m_htiShowCatNames = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_CAT_SHOWCATNAME), m_htiSCC, m_bShowCatNames);
		m_htiSelectCat = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_CAT_SHOWSELCATDLG), m_htiSCC, m_bSelectCat);
		m_htiUseAutoCat = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_CAT_USEAUTOCAT), m_htiSCC, m_bUseAutoCat);
		m_htiUseActiveCat = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_CAT_USEACTIVE), m_htiSCC, m_bUseActiveCat);
		m_htiAutoSetResOrder = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_CAT_AUTORESUMEORD), m_htiSCC, m_bAutoSetResOrder);
		m_htiSmallFileDLPush = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_CAT_SMALLFILEDLPUSH), m_htiSCC, m_bSmallFileDLPush);
		m_htiResumeFileInNewCat = m_ctrlTreeOptions.InsertItem(GetResString(IDS_CAT_STARTFILESONADD), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiSCC);
		m_ctrlTreeOptions.AddEditBox(m_htiResumeFileInNewCat, RUNTIME_CLASS(CNumTreeOptionsEdit));
//dlarge end

//dlarge Misc Settings
		m_htiMisc = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_MISC), iImgMisc, TVI_ROOT);
		m_htiSUQWT = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_SUQWT), m_htiMisc, m_bSUQWT); //dlarge SUQWT 
		m_htiStaticIcon = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_STATIC_ICON),m_htiMisc, m_bStaticIcon); //dlarge Static Tray Icon
		m_htiTrayComplete = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_TRAY_COMPLETE), m_htiMisc, m_bTrayComplete); //dlarge Completed in Tray 
		m_htiAutoSharedUpdater = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_AUTO_SHARED_UPDATER), m_htiMisc, m_bAutoSharedUpdater); //dlarge Automatic shared files updater 
//dlarge end

//Expand Settings
                m_ctrlTreeOptions.Expand(m_htiSCC, TVE_EXPAND);
                m_ctrlTreeOptions.Expand(m_htiMisc, TVE_EXPAND);
                m_ctrlTreeOptions.Expand(m_htiHighProcess, TVE_EXPAND);
                m_ctrlTreeOptions.Expand(m_htiQuickStart, TVE_EXPAND);
                m_ctrlTreeOptions.Expand(m_htiDropSources, TVE_EXPAND);
	        m_ctrlTreeOptions.Expand(hGrpAPrio, TVE_EXPAND);
                m_ctrlTreeOptions.Expand(m_htiMoreTweaksGroup, TVE_EXPAND);
                m_ctrlTreeOptions.Expand(m_htiDynUpSUC, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiXPMenu, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiXPMenuStyle, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiMMGroup, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiSysInfoGroup, TVE_EXPAND);
//Expand Settings

//Bold Settings
                m_ctrlTreeOptions.SetItemState(m_htiSCC, TVIS_BOLD, TVIS_BOLD);
                m_ctrlTreeOptions.SetItemState(m_htiMisc, TVIS_BOLD, TVIS_BOLD);
                m_ctrlTreeOptions.SetItemState(m_htiHighProcess, TVIS_BOLD, TVIS_BOLD);
                m_ctrlTreeOptions.SetItemState(m_htiQuickStart, TVIS_BOLD, TVIS_BOLD);
                m_ctrlTreeOptions.SetItemState(m_htiDropSources, TVIS_BOLD, TVIS_BOLD);
		m_ctrlTreeOptions.SetItemState(hGrpAPrio, TVIS_BOLD, TVIS_BOLD);
	        m_ctrlTreeOptions.SetItemState(m_htiMoreTweaksGroup, TVIS_BOLD, TVIS_BOLD);
	        m_ctrlTreeOptions.SetItemState(m_htiXPMenu, TVIS_BOLD, TVIS_BOLD);
	        m_ctrlTreeOptions.SetItemState(m_htiMMGroup, TVIS_BOLD, TVIS_BOLD);
	        m_ctrlTreeOptions.SetItemState(m_htiSysInfoGroup, TVIS_BOLD, TVIS_BOLD);
//Bold Settings

		m_ctrlTreeOptions.SendMessage(WM_VSCROLL, SB_TOP);
		m_bInitializedTreeOpts = true;
	}

//dlarge QuickStart
		DDX_TreeCheck(pDX,IDC_TWEAKS2_OPTS, m_htiQuickStartEnable, m_bQuickStart);
		DDX_TreeEdit(pDX,IDC_TWEAKS2_OPTS, m_htiQuickStartTime, m_iQuickStartTime);
		//DDX_TreeEdit(pDX,IDC_TWEAKS2_OPTS, m_htiQuickStartTimePerFile, m_iQuickStartTimePerFile);
		DDX_TreeEdit(pDX,IDC_TWEAKS2_OPTS, m_htiQuickMaxConperFive, m_iQuickMaxConperFive);
		DDX_TreeEdit(pDX,IDC_TWEAKS2_OPTS, m_htiQuickMaxHalfOpen, m_iQuickMaxHalfOpen);
		DDX_TreeEdit(pDX,IDC_TWEAKS2_OPTS, m_htiQuickMaxConnections, m_iQuickMaxConnections);
//dlarge end

//dlarge high process priority 
	    DDX_TreeRadio(pDX, IDC_TWEAKS2_OPTS, m_htiHighProcess, m_iHighProcessMode);
//dlarge end 

//dlarge auto priority
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, hUseAPrio, bUseAPrio);
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, hAPrioKeepLow, bAPrioKeepLow);
	DDX_TreeEdit(pDX, IDC_TWEAKS2_OPTS, hAPrioHigh, iAPrioHigh);
	DDV_MinMaxInt(pDX, iAPrioHigh, 1, 99);
	DDX_TreeEdit(pDX, IDC_TWEAKS2_OPTS, hAPrioNorm, iAPrioNorm);
	DDV_MinMaxInt(pDX, iAPrioNorm, 1, iAPrioHigh-1);
//dlarge end

//dlarge Drop
		DDX_TreeEdit(pDX, IDC_TWEAKS2_OPTS, m_htiHqrBox, iMaxRemoveQRS);
		DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiDropSourcesNNS, m_iDropSourcesNNS);
		DDX_TreeEdit(pDX, IDC_TWEAKS2_OPTS, m_htiDropSourcesTimerNNS, m_iDropSourcesTimerNNS);
		DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiDropSourcesFQ, m_iDropSourcesFQ);
		DDX_TreeEdit(pDX, IDC_TWEAKS2_OPTS, m_htiDropSourcesTimerFQ, m_iDropSourcesTimerFQ);
		DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiDropSourcesHQR, m_iDropSourcesHQR);
		DDX_TreeEdit(pDX, IDC_TWEAKS2_OPTS, m_htiDropSourcesTimerHQR, m_iDropSourcesTimerHQR);
		DDV_MinMaxInt(pDX, iMaxRemoveQRS, 2500, 100000);
//dlarge end

//dlarge SUC
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiDynUpSUC, m_bDynUpMode);
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiSUCLog, m_bSUCLog);
	DDX_TreeEdit(pDX, IDC_TWEAKS2_OPTS, m_htiSUCHigh, m_iSUCHigh);
	DDV_MinMaxInt(pDX, m_iSUCHigh, 350, 1000);
	DDX_TreeEdit(pDX, IDC_TWEAKS2_OPTS, m_htiSUCLow, m_iSUCLow);
	DDV_MinMaxInt(pDX, m_iSUCLow, 350, m_iSUCHigh);
	DDX_TreeEdit(pDX, IDC_TWEAKS2_OPTS, m_htiSUCPitch, m_iSUCPitch);
	DDV_MinMaxInt(pDX, m_iSUCPitch, 2500, 10000);
	DDX_TreeEdit(pDX, IDC_TWEAKS2_OPTS, m_htiSUCDrift, m_iSUCDrift);
	DDV_MinMaxInt(pDX, m_iSUCDrift, 0, 100);
//dlarge end

// NEO: NMX - [NeoMenuXP]
	DDX_TreeRadio(pDX, IDC_TWEAKS2_OPTS,m_htiXPMenuStyle,m_iXPMenuStyle);
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS,m_htiShowXPSideBar,m_bShowXPSideBar);
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS,m_htiShowXPBitmap,m_bShowXPBitmap);
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS,m_htiGrayMenuIcon,m_bGrayMenuIcon);
// NEO: NMX END

//dlarge CPU/MEM 
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiSysInfo, m_bSysInfo);
	if(m_htiSysInfoGlobal) DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiSysInfoGlobal, m_bSysInfoGlobal);
	if (m_htiSysInfoGlobal)	m_ctrlTreeOptions.SetCheckBoxEnable(m_htiSysInfoGlobal, m_bSysInfo);
//dlarge end 

//dlarge Display Settings
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiQueueProgressBar, m_bQueueProgressBar); //dlarge Client queue progress bar 
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiShowClientPercentage, m_bShowClientPercentage); //dlarge Client Percentage 
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiEnableChunkDots, m_bEnableChunkDots);//dlarge ChunkDots
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiSessionDownload, m_bShowSessionDownload);//dlarge Session Download
//dlarge end

//dlarge minimule 
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiShowMM, m_bShowMM);
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiMMLives, m_bMMLives);
	DDX_TreeEdit(pDX, IDC_TWEAKS2_OPTS, m_htiMMUpdateTime, m_iMMUpdateTime);
	DDV_MinMaxInt(pDX, m_iMMUpdateTime, 0, MIN2S(60));
	DDX_TreeEdit(pDX, IDC_TWEAKS2_OPTS, m_htiMMTrans, m_iMMTrans);
	DDV_MinMaxInt(pDX, m_iMMTrans, 1, 255);
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiMMCompl, m_bMMCompl);
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiMMOpen, m_bMMOpen);
//dlarge end

//dlarge Smart Category Control 
	DDX_TreeRadio(pDX, IDC_TWEAKS2_OPTS, m_htiDlMode, (int &)m_iDlMode);
	DDX_TreeEdit(pDX, IDC_TWEAKS2_OPTS, m_htiResumeFileInNewCat, m_iResumeFileInNewCat);
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiShowCatNames, m_bShowCatNames);
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiSelectCat, m_bSelectCat);
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiUseActiveCat, m_bUseActiveCat);
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiAutoSetResOrder, m_bAutoSetResOrder);
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiSmallFileDLPush, m_bSmallFileDLPush);
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiUseAutoCat, m_bUseAutoCat);
//dlarge end

//dlarge Misc Settings
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiSUQWT, m_bSUQWT); //dlarge SUQWT 
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiStaticIcon, m_bStaticIcon); //dlarge Static Tray Icon
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiTrayComplete, m_bTrayComplete); //dlarge Completed in Tray 
	DDX_TreeCheck(pDX, IDC_TWEAKS2_OPTS, m_htiAutoSharedUpdater, m_bAutoSharedUpdater); //dlarge Automatic shared files updater 
//dlarge end
}

BOOL CPPgTweaks2::OnInitDialog()
{
//dlarge QuickStart
	m_bQuickStart = thePrefs.m_bQuickStart;
	m_iQuickStartTime = thePrefs.m_iQuickStartTime;
	//m_iQuickStartTimePerFile = thePrefs.m_iQuickStartTimePerFile;
	m_iQuickMaxConperFive = thePrefs.m_iQuickMaxConperFive;
	m_iQuickMaxHalfOpen = thePrefs.m_iQuickMaxHalfOpen;
	m_iQuickMaxConnections = thePrefs.m_iQuickMaxConnections;
//dlarge end

//dlarge high process priority 
	m_iHighProcessMode = thePrefs.GetProcessPrio();
//dlarge end

//dlarge Drop
	m_iDropSourcesNNS = thePrefs.m_bDropSourcesNNS;
	m_iDropSourcesTimerNNS = thePrefs.m_iDropSourcesTimerNNS;
	m_iDropSourcesFQ = thePrefs.m_bDropSourcesFQ;
	m_iDropSourcesTimerFQ = thePrefs.m_iDropSourcesTimerFQ;
	m_iDropSourcesHQR = thePrefs.m_bDropSourcesHQR;
	m_iDropSourcesTimerHQR = thePrefs.m_iDropSourcesTimerHQR;
    iMaxRemoveQRS = /*(int)*/ thePrefs.GetMaxRemoveQRS();
//dlarge Drop

//dlarge auto priority
	bUseAPrio = thePrefs.pp_bUseAutoPrio ;
	bAPrioKeepLow = thePrefs.pp_bAutoPrioKeepLow;
	iAPrioHigh = thePrefs.pp_uAutoPrioHigh;
	iAPrioNorm = thePrefs.pp_uAutoPrioNormal;
//dlarge end

//dlarge SUC
	m_bDynUpMode = thePrefs.m_bSUCEnabled;
	m_bSUCLog =  thePrefs.m_bSUCLog;
	m_iSUCHigh = thePrefs.m_iSUCHigh;
	m_iSUCLow = thePrefs.m_iSUCLow;
	m_iSUCPitch = thePrefs.m_iSUCPitch;
	m_iSUCDrift = thePrefs.m_iSUCDrift;
//dlarge end

// NEO: NMX - [NeoMenuXP]
	m_bShowXPSideBar = thePrefs.m_bShowXPSideBar;
	m_bShowXPBitmap = thePrefs.m_bShowXPBitmap;
	m_iXPMenuStyle = thePrefs.m_iXPMenuStyle;
	m_bGrayMenuIcon = thePrefs.m_bGrayMenuIcon;
// NEO: NMX END

//dlarge CPU/MEM 
	m_bSysInfo = thePrefs.GetSysInfo();
	m_bSysInfoGlobal = thePrefs.GetSysInfoGlobal();
//dlarge end

//dlarge Display Settings
	m_bQueueProgressBar = thePrefs.ShowClientQueueProgressBar(); //dlarge Client queue progress bar
	m_bShowClientPercentage = thePrefs.GetShowClientPercentage(); //dlarge Client Percentage 
	m_bEnableChunkDots = thePrefs.m_bEnableChunkDots;//dlarge ChunkDots
	m_bShowSessionDownload = thePrefs.m_bShowSessionDownload;//dlarge Session Download
//dlarge end

//dlarge minimule 
	m_bShowMM = thePrefs.IsMiniMuleEnabled();
	m_bMMLives = thePrefs.GetMiniMuleLives();
	m_iMMUpdateTime = thePrefs.GetMiniMuleUpdate();
	m_iMMTrans = thePrefs.GetMiniMuleTransparency();
	m_bMMCompl = thePrefs.m_bMMCompl;
	m_bMMOpen = thePrefs.m_bMMOpen;
//dlarge end

//dlarge Smart Category Control 
	m_iDlMode = thePrefs.GetDlMode();
	m_bShowCatNames = thePrefs.ShowCatNameInDownList();
	m_bSelectCat = thePrefs.SelectCatForNewDL();
	m_bUseActiveCat = thePrefs.UseActiveCatForLinks();
	m_bAutoSetResOrder = thePrefs.AutoSetResumeOrder();
	m_bSmallFileDLPush = thePrefs.SmallFileDLPush();
	m_iResumeFileInNewCat = thePrefs.StartDLInEmptyCats();
	m_bUseAutoCat = thePrefs.UseAutoCat();
//dlarge end

//dlarge Misc Settings
	m_bSUQWT = thePrefs.SaveUploadQueueWaitTime(); //dlarge SUQWT 
	m_bStaticIcon = thePrefs.GetStaticIcon(); //dlarge Static Tray Icon
	m_bTrayComplete = thePrefs.GetTrayComplete(); //dlarge Completed in Tray 
	m_bAutoSharedUpdater = thePrefs.GetDirectoryWatcher(); //dlarge Automatic shared files updater 
//dlarge end

	InitWindowStyles(this);
	CPropertyPage::OnInitDialog();
	Localize();
	LoadSettings();
	return TRUE;

}

BOOL CPPgTweaks2::OnKillActive()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();
	return CPropertyPage::OnKillActive();
}

void CPPgTweaks2::Localize(void)
{	
	if(m_hWnd)
	{
		CString buffer;
		SetWindowText(VERSION_MOD);

//dlarge high process priority 
		if (m_htiHighProcess) m_ctrlTreeOptions.SetItemText(m_htiHighProcess, GetResString(IDS_HIGHPROCESS));
		if (m_htiHighProcessMode_low) m_ctrlTreeOptions.SetItemText(m_htiHighProcessMode_low, GetResString(IDS_LOW_PROCESS));
		if (m_htiHighProcessMode_lower) m_ctrlTreeOptions.SetItemText(m_htiHighProcessMode_lower, GetResString(IDS_LOWER_PROCESS));
		if (m_htiHighProcessMode_normal) m_ctrlTreeOptions.SetItemText(m_htiHighProcessMode_normal, GetResString(IDS_NORMAL_PROCESS));
		if (m_htiHighProcessMode_higher) m_ctrlTreeOptions.SetItemText(m_htiHighProcessMode_higher, GetResString(IDS_HIGHER_PROCESS));
		if (m_htiHighProcessMode_high) m_ctrlTreeOptions.SetItemText(m_htiHighProcessMode_high, GetResString(IDS_HIGH_PROCESS));
//dlarge end 

//dlarge SUC
	if (m_htiMoreTweaksGroup) m_ctrlTreeOptions.SetItemText(m_htiMoreTweaksGroup, GetResString(IDS_SUC_GROUP));
		CString Buffer;
		if (m_htiSUCHigh){
			Buffer.Format(GetResString(IDS_SUC_HIGH),900);
			m_ctrlTreeOptions.SetEditLabel(m_htiSUCHigh, Buffer);
			//SetTool(m_htiSUCHigh,IDS_SUC_HIGH_TIP);
		}
		if (m_htiSUCLow){
			Buffer.Format(GetResString(IDS_SUC_LOW),600);
			m_ctrlTreeOptions.SetEditLabel(m_htiSUCLow, Buffer);
			//SetTool(m_htiSUCLow,IDS_SUC_LOW_TIP);
		}
		if (m_htiSUCPitch){
			Buffer.Format(GetResString(IDS_SUC_PITCH),3000);
			m_ctrlTreeOptions.SetEditLabel(m_htiSUCPitch, Buffer);
			//SetTool(m_htiSUCPitch,IDS_SUC_PITCH_TIP);
		}
		if (m_htiSUCDrift){
			Buffer.Format(GetResString(IDS_SUC_DRIFT),50);
			m_ctrlTreeOptions.SetEditLabel(m_htiSUCDrift, Buffer);
			//SetTool(m_htiSUCDrift,IDS_SUC_DRIFT_TIP);
		}
		if (m_htiDynUpSUC) {m_ctrlTreeOptions.SetItemText(m_htiDynUpSUC, GetResString(IDS_SUC));
							//SetTool(m_htiDynUpSUC,IDS_SUC_TIP);
		}
//dlarge end

//dlarge CPU/MEM 
		if (m_htiSysInfo) m_ctrlTreeOptions.SetItemText(m_htiSysInfo, GetResString(IDS_SUC_ENABLED));
		if (m_htiSysInfoGlobal) m_ctrlTreeOptions.SetItemText(m_htiSysInfoGlobal, GetResString(IDS_SYS_INFO_GLOBAL));
//dlarge end

//dlarge Display Settings
		if (m_htiQueueProgressBar) m_ctrlTreeOptions.SetItemText(m_htiQueueProgressBar, GetResString(IDS_CLIENTQUEUEPROGRESSBAR)); //dlarge Client queue progress bar  
		if (m_htiShowClientPercentage) m_ctrlTreeOptions.SetItemText(m_htiShowClientPercentage, GetResString(IDS_CLIENTPERCENTAGE)); //dlarge Client Percentage  
                if (m_htiEnableChunkDots) m_ctrlTreeOptions.SetItemText(m_htiEnableChunkDots, GetResString(IDS_ENABLE_CHUNKDOTS)); //dlarge ChunkDots
                if (m_htiSessionDownload) m_ctrlTreeOptions.SetItemText(m_htiSessionDownload, GetResString(IDS_SESSION_DOWNLOAD)); //dlarge Session Download
//dlarge end

//dlarge minimule 
		if (m_htiMMGroup) m_ctrlTreeOptions.SetItemText(m_htiMMGroup, _T("Mini-Mule Settings"));
		if (m_htiShowMM) m_ctrlTreeOptions.SetItemText(m_htiShowMM, GetResString(IDS_MM_SHOW));
		if (m_htiMMLives) m_ctrlTreeOptions.SetItemText(m_htiMMLives, GetResString(IDS_MM_LIVES));
		if (m_htiMMUpdateTime) m_ctrlTreeOptions.SetEditLabel(m_htiMMUpdateTime, GetResString(IDS_MM_UPDATE_TIME));
		if (m_htiMMTrans) m_ctrlTreeOptions.SetEditLabel(m_htiMMTrans, GetResString(IDS_MM_TRANS));
		if (m_htiMMCompl) m_ctrlTreeOptions.SetItemText(m_htiMMCompl, GetResString(IDS_MM_COMPL));
		if (m_htiMMOpen) m_ctrlTreeOptions.SetItemText(m_htiMMOpen, GetResString(IDS_MM_OPEN));
//dlarge end

//dlarge Smart Category Control 
		if (m_htiShowCatNames) m_ctrlTreeOptions.SetItemText(m_htiShowCatNames, GetResString(IDS_CAT_SHOWCATNAME));
		if (m_htiSelectCat) m_ctrlTreeOptions.SetItemText(m_htiSelectCat, GetResString(IDS_CAT_SHOWSELCATDLG));
		if (m_htiUseAutoCat) m_ctrlTreeOptions.SetItemText(m_htiUseAutoCat, GetResString(IDS_CAT_USEAUTOCAT));
                if (m_htiUseActiveCat) m_ctrlTreeOptions.SetItemText(m_htiUseActiveCat, GetResString(IDS_CAT_USEACTIVE));
		if (m_htiAutoSetResOrder) m_ctrlTreeOptions.SetItemText(m_htiAutoSetResOrder, GetResString(IDS_CAT_AUTORESUMEORD));
		if (m_htiSmallFileDLPush) m_ctrlTreeOptions.SetItemText(m_htiSmallFileDLPush, GetResString(IDS_CAT_SMALLFILEDLPUSH));
		if (m_htiResumeFileInNewCat) m_ctrlTreeOptions.SetEditLabel(m_htiResumeFileInNewCat, GetResString(IDS_CAT_STARTFILESONADD));
//dlarge end

//dlarge Misc Settings
		if (m_htiSUQWT) m_ctrlTreeOptions.SetItemText(m_htiSUQWT, GetResString(IDS_SUQWT)); //dlarge SUQWT 
		if (m_htiStaticIcon) m_ctrlTreeOptions.SetItemText(m_htiStaticIcon, GetResString(IDS_STATIC_ICON)); //dlarge Static Tray Icon
		if (m_htiTrayComplete) m_ctrlTreeOptions.SetItemText(m_htiTrayComplete, GetResString(IDS_TRAY_COMPLETE)); //dlarge Completed in Tray 
//dlarge end

	}
}

BOOL CPPgTweaks2::OnApply()
{
	m_ctrlTreeOptions.HandleChildControlLosingFocus();

	if (!UpdateData())
		return FALSE;


//dlarge QuickStart
	thePrefs.m_bQuickStart = m_bQuickStart;
	if(m_iQuickStartTime > 18)
	thePrefs.m_iQuickStartTime = 18;
	else if(m_iQuickStartTime < 8)
	thePrefs.m_iQuickStartTime = 8;
	else thePrefs.m_iQuickStartTime = m_iQuickStartTime;
	//thePrefs.m_iQuickStartTimePerFile = m_iQuickStartTimePerFile;
	if(m_iQuickMaxConperFive > 200)
	thePrefs.m_iQuickMaxConperFive = 200;
	else if(m_iQuickMaxConperFive < 5)
	thePrefs.m_iQuickMaxConperFive = 5;
	else thePrefs.m_iQuickMaxConperFive = m_iQuickMaxConperFive;
	if(m_iQuickMaxHalfOpen > 100)
	thePrefs.m_iQuickMaxHalfOpen = 100;
	else if(m_iQuickMaxHalfOpen < 2)
	thePrefs.m_iQuickMaxHalfOpen = 2;
	else thePrefs.m_iQuickMaxHalfOpen = m_iQuickMaxHalfOpen;
	if(m_iQuickMaxConnections > 4000)
	thePrefs.m_iQuickMaxConnections = 4000;
	else if(m_iQuickMaxConnections < 200)
	thePrefs.m_iQuickMaxConnections = 200;
	else thePrefs.m_iQuickMaxConnections = m_iQuickMaxConnections;
//dlarge end

//dlarge high process priority 
	thePrefs.SetProcessPrio(m_iHighProcessMode);
//dlarge end 

//dlarge Drop
	if(m_iDropSourcesTimerNNS < 2)
		thePrefs.m_iDropSourcesTimerNNS = 2;
	else thePrefs.m_iDropSourcesTimerNNS = m_iDropSourcesTimerNNS;

	if(m_iDropSourcesTimerFQ < 2)
		thePrefs.m_iDropSourcesTimerFQ = 2;
	else thePrefs.m_iDropSourcesTimerFQ = m_iDropSourcesTimerFQ;

	if(m_iDropSourcesTimerHQR < 2)
		thePrefs.m_iDropSourcesTimerHQR = 2;
	else thePrefs.m_iDropSourcesTimerHQR = m_iDropSourcesTimerHQR;
	
	thePrefs.SetDropSourcesNNS(m_iDropSourcesNNS);
	thePrefs.SetDropSourcesFQ(m_iDropSourcesFQ);
	thePrefs.SetDropSourcesHQR(m_iDropSourcesHQR);
	thePrefs.SetMaxRemoveQRS((uint16)(iMaxRemoveQRS ? iMaxRemoveQRS : 3000));
//dlarge end

//dlarge auto priority
	thePrefs.pp_bAutoPrioChanged = (thePrefs.pp_bUseAutoPrio != bUseAPrio) || (thePrefs.pp_bAutoPrioKeepLow != bAPrioKeepLow) || (thePrefs.pp_uAutoPrioHigh != iAPrioHigh) || (thePrefs.pp_uAutoPrioNormal != iAPrioNorm);
	thePrefs.pp_bUseAutoPrio     = bUseAPrio;
	thePrefs.pp_bAutoPrioKeepLow = bAPrioKeepLow;
	thePrefs.pp_uAutoPrioHigh    = (uint8)iAPrioHigh;
	thePrefs.pp_uAutoPrioNormal  = (uint8)iAPrioNorm;
//dlarge end

//dlarge SUC
	thePrefs.m_bSUCEnabled = m_bDynUpMode;
	thePrefs.m_bSUCLog = m_bSUCLog;
	thePrefs.m_iSUCHigh = m_iSUCHigh;
	thePrefs.m_iSUCLow = m_iSUCLow;
	thePrefs.m_iSUCPitch = m_iSUCPitch;
	thePrefs.m_iSUCDrift = m_iSUCDrift;
//dlarge end

// NEO: NMX - [NeoMenuXP]
	if( thePrefs.m_bShowXPSideBar != m_bShowXPSideBar
	 || thePrefs.m_bShowXPBitmap != m_bShowXPBitmap
	 || thePrefs.m_iXPMenuStyle != m_iXPMenuStyle
	 || thePrefs.m_bGrayMenuIcon != m_bGrayMenuIcon)
	{
		thePrefs.m_bShowXPSideBar = m_bShowXPSideBar;
		thePrefs.m_bShowXPBitmap = m_bShowXPBitmap;
		thePrefs.m_iXPMenuStyle = m_iXPMenuStyle;
		thePrefs.m_bGrayMenuIcon = m_bGrayMenuIcon;

		theApp.emuledlg->transferwnd->downloadlistctrl.CreateMenues();
		theApp.emuledlg->searchwnd->CreateMenus();
		theApp.emuledlg->searchwnd->m_pwndResults->searchlistctrl.CreateMenues();
		theApp.emuledlg->sharedfileswnd->sharedfilesctrl.CreateMenues();
	}
// NEO: NMX END

//dlarge CPU/MEM  
	if(thePrefs.m_bSysInfo != m_bSysInfo)
	{
		thePrefs.m_bSysInfo = m_bSysInfo;
		theApp.emuledlg->transferwnd->EnableSysInfo(m_bSysInfo);
	}
	thePrefs.m_bSysInfoGlobal = m_bSysInfoGlobal;
//dlarge end

//dlarge Display Settings
	thePrefs.m_bClientQueueProgressBar = m_bQueueProgressBar; //dlarge Client queue progress bar 
	thePrefs.m_bShowClientPercentage = m_bShowClientPercentage; //dlarge Client Percentage 
	thePrefs.m_bEnableChunkDots = m_bEnableChunkDots;//dlarge ChunkDots
	thePrefs.m_bShowSessionDownload = m_bShowSessionDownload;//dlarge Session download
//dlarge end

//dlarge minimule 
	thePrefs.m_bMiniMule = m_bShowMM;
	thePrefs.SetMiniMuleLives(m_bMMLives);
	thePrefs.m_iMiniMuleUpdate = m_iMMUpdateTime;
	thePrefs.SetMiniMuleTransparency((uint8)m_iMMTrans);
	thePrefs.m_bMMCompl = m_bMMCompl;
	thePrefs.m_bMMOpen = m_bMMOpen;
//dlarge end

//dlarge Smart Category Control 
	thePrefs.dlMode = (uint8)m_iDlMode;
	thePrefs.m_bShowCatNames = m_bShowCatNames;
	thePrefs.m_bSelCatOnAdd = m_bSelectCat;
	thePrefs.m_bActiveCatDefault = m_bUseActiveCat;
	thePrefs.m_bAutoSetResumeOrder = m_bAutoSetResOrder;
	thePrefs.m_bSmallFileDLPush = m_bSmallFileDLPush;
	thePrefs.m_iStartDLInEmptyCats = (uint8)m_iResumeFileInNewCat;
	thePrefs.m_bUseAutoCat = m_bUseAutoCat;
//dlarge end

//dlarge Misc Settings
//dlarge SUQWT 
	bool bRestartApp = false;
	if(thePrefs.m_bSaveUploadQueueWaitTime != m_bSUQWT)
	{
		thePrefs.m_bSaveUploadQueueWaitTime = m_bSUQWT;
		bRestartApp = true;
	}
//dlarge end
//dlarge Static Tray Icon start
	if(m_bStaticIcon != thePrefs.m_bStaticIcon)
	{
		if(m_bStaticIcon)
			//dlarge minimule 
			theApp.emuledlg->TrayShow(FALSE);
			//dlarge minimule 
		else if(theApp.emuledlg->IsWindowVisible()) //only hide when window visible
			theApp.emuledlg->TrayHide();
	}
	thePrefs.m_bStaticIcon = m_bStaticIcon;
//dlarge Static Tray Icon end
	thePrefs.m_bTrayComplete = m_bTrayComplete; //dlarge Completed in Tray 
	thePrefs.m_bDirectoryWatcher = m_bAutoSharedUpdater; //dlarge Automatic shared files updater 
//dlarge end

	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

void CPPgTweaks2::LoadSettings(void)
{   
}

void CPPgTweaks2::OnDestroy()
{

	m_ctrlTreeOptions.DeleteAllItems();
	m_ctrlTreeOptions.DestroyWindow();
	m_bInitializedTreeOpts = false;

	m_htiMoreTweaksGroup = NULL;

//dlarge QuickStart
		m_htiQuickStart = NULL;
			m_htiQuickStartEnable = NULL;
			m_htiQuickStartTime = NULL;
			//m_htiQuickStartTimePerFile = NULL;
			m_htiQuickMaxConperFive = NULL;
			m_htiQuickMaxHalfOpen = NULL;
			m_htiQuickMaxConnections = NULL;
//dlarge end

//dlarge  high process priority 
	m_htiHighProcess = NULL;
	m_htiHighProcessMode_low = NULL;
	m_htiHighProcessMode_lower = NULL;
	m_htiHighProcessMode_normal = NULL;
	m_htiHighProcessMode_higher = NULL;
	m_htiHighProcessMode_high = NULL;
//dlarge  end 

//dlarge Drop
	m_htiDropSources = NULL;
	m_htiDropSourcesTimerNNS = NULL;
	m_htiDropSourcesTimerFQ = NULL;
	m_htiDropSourcesTimerHQR = NULL;
	m_htiDropSourcesNNS = NULL;
	m_htiDropSourcesFQ = NULL;
	m_htiDropSourcesHQR = NULL;
    m_htiHqrBox = NULL;
//dlarge end

//dlarge auto priority
	hGrpAPrio = NULL;
	hUseAPrio = NULL;
	hAPrioHigh = NULL;
	hAPrioNorm = NULL;
	hAPrioKeepLow = NULL;
//dlarge end

//dlarge SUC
	m_htiDynUpSUC = NULL;
	m_htiSUCLog = NULL;
	m_htiSUCHigh = NULL;
	m_htiSUCLow = NULL;
	m_htiSUCPitch = NULL;
	m_htiSUCDrift = NULL;
//dlarge end

//CPU/MEM usage 
	m_htiSysInfoGroup = NULL;
	m_htiSysInfo = NULL;
	m_htiSysInfoGlobal = NULL;
//dlarge end

//dlarge Display Settings
	m_htiQueueProgressBar = NULL; //dlarge Queue Progress Bar
	m_htiShowClientPercentage = NULL; //dlarge Client Percentage   
	m_htiEnableChunkDots = NULL; //dlarge chunk dots
	m_htiSessionDownload = NULL; //dlarge Session Download
//dlarge end

//dlarge minimule 
	m_htiMMGroup = NULL;
	m_htiShowMM = NULL;
	m_htiMMLives = NULL;
	m_htiMMUpdateTime = NULL;
	m_htiMMTrans = NULL;
	m_htiMMCompl = NULL;
	m_htiMMOpen = NULL;
//dlarge end 

//dlarge Smart Category Control 
	m_htiSCC = NULL;
	m_htiDlMode = NULL;
	m_htiDlNone = NULL;
	m_htiDlAlph = NULL;
	m_htiDlLP = NULL;
	m_htiShowCatNames = NULL;
	m_htiSelectCat = NULL;
	m_htiUseActiveCat = NULL;
	m_htiAutoSetResOrder = NULL;
	m_htiSmallFileDLPush = NULL;
	m_htiResumeFileInNewCat = NULL;
	m_htiUseAutoCat = NULL;
//dlarge end

//dlarge Misc Settings
	m_htiMisc = NULL;
	m_htiSUQWT = NULL; //dlarge SUQWT 
	m_htiTrayComplete = NULL; //dlarge Completed in Tray 
	m_htiAutoSharedUpdater = NULL; //dlarge Automatic shared files updater 
//dlarge end


	CPropertyPage::OnDestroy();
}

LRESULT CPPgTweaks2::OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam)
{
	if (wParam == IDC_TWEAKS2_OPTS)
	{
		TREEOPTSCTRLNOTIFY* pton = (TREEOPTSCTRLNOTIFY*)lParam;
		if(pton->nmhdr.code == EN_KILLFOCUS) // NEO: FIX - [TreeControl] 
			return 0;
	SetModified();
	}
	return 0;
}
